#include <bits/stdc++.h>

enum class KrvnaGrupa {
	O,
	A,
	B,
	AB
};

struct Pacijent {
	KrvnaGrupa krvna_grupa;
	size_t potrebne_jedinice;
};

using Raspodela = std::array<size_t, 4>;

auto karakter_u_kg(const char c) -> KrvnaGrupa {
	switch (c) {
		case 'A':
			return KrvnaGrupa::A;
		case 'B':
			return KrvnaGrupa::B;
		case 'O':
			return KrvnaGrupa::O;
		default:
			return KrvnaGrupa::AB;				
	}
}

template <typename T>
auto ucitaj() -> T {
	T t;
	std::cin >> t;
	return t;
}

template <>
auto ucitaj() -> Pacijent {
	Pacijent pacijent;

	const auto grupa = ucitaj<std::string>();
	pacijent.krvna_grupa = grupa.length() > 1 ? KrvnaGrupa::AB : karakter_u_kg(grupa[0]);

	pacijent.potrebne_jedinice = ucitaj<size_t>();

	return pacijent;
}

auto main() -> int {
	Raspodela rezerve;

	static constexpr auto idxO = static_cast<size_t>(KrvnaGrupa::O);
	static constexpr auto idxA = static_cast<size_t>(KrvnaGrupa::A);
	static constexpr auto idxB = static_cast<size_t>(KrvnaGrupa::B);
	static constexpr auto idxAB = static_cast<size_t>(KrvnaGrupa::AB);

	const auto n = ucitaj<size_t>();

	rezerve[idxO] = ucitaj<size_t>();
	rezerve[idxA] = ucitaj<size_t>();
	rezerve[idxB] = ucitaj<size_t>();
	rezerve[idxAB] = ucitaj<size_t>();

	std::vector<Pacijent> pacijenti;
	std::vector<Raspodela> raspodele;

	for (size_t i = 0; i < n; ++i) {
		pacijenti.push_back(ucitaj<Pacijent>());
		raspodele.push_back(std::array<size_t, 4>{ 0, 0, 0, 0 });
	}

	static constexpr std::array<KrvnaGrupa, 4> aktivne_grupe{ KrvnaGrupa::O, KrvnaGrupa::A, KrvnaGrupa::B, KrvnaGrupa::AB };

	for (const auto aktivna_grupa : aktivne_grupe) {
		for (size_t i = 0; i < n; ++i) {
			auto& raspodela = raspodele[i];
			auto& pacijent = pacijenti[i];

			if (pacijent.krvna_grupa != aktivna_grupa) {
				continue;
			}
			
			if (pacijent.krvna_grupa == KrvnaGrupa::O) {
				if (pacijent.potrebne_jedinice > rezerve[idxO]) {
					std::cout << "nemoguce\n";
					return 0;
				}
				rezerve[idxO] -= pacijent.potrebne_jedinice;

				raspodela[idxO] = pacijent.potrebne_jedinice;
				continue;
			}

			if (pacijent.krvna_grupa == KrvnaGrupa::A) {
				if (pacijent.potrebne_jedinice > rezerve[idxO] + rezerve[idxA]) {
					std::cout << "nemoguce\n";
					return 0;
				}

				if (rezerve[idxA] >= pacijent.potrebne_jedinice) {
					rezerve[idxA] -= pacijent.potrebne_jedinice;
					raspodela[idxA] = pacijent.potrebne_jedinice;
					continue;
				}

				raspodela[idxA] += rezerve[idxA];
				pacijent.potrebne_jedinice -= rezerve[idxA];
				rezerve[idxA] = 0;

				raspodela[idxO] += pacijent.potrebne_jedinice;
				rezerve[idxO] -= pacijent.potrebne_jedinice;

				continue;
			}

			if (pacijent.krvna_grupa == KrvnaGrupa::B) {
				if (pacijent.potrebne_jedinice > rezerve[idxO] + rezerve[idxB]) {
					std::cout << "nemoguce\n";
					return 0;
				}

				if (rezerve[idxB] >= pacijent.potrebne_jedinice) {
					rezerve[idxB] -= pacijent.potrebne_jedinice;
					raspodela[idxB] = pacijent.potrebne_jedinice;
					continue;
				}

				raspodela[idxB] += rezerve[idxB];
				pacijent.potrebne_jedinice -= rezerve[idxB];
				rezerve[idxB] = 0;

				raspodela[idxO] += pacijent.potrebne_jedinice;
				rezerve[idxO] -= pacijent.potrebne_jedinice;

				continue;
			}

			if (pacijent.krvna_grupa == KrvnaGrupa::AB) {
				const auto ostalo = std::accumulate(begin(rezerve), end(rezerve), (size_t)0);

				if (ostalo < pacijent.potrebne_jedinice) {
					std::cout << "nemoguce\n";
					return 0;
				}

				for (size_t j = 0; j < 4 || pacijent.potrebne_jedinice == j; ++j) {
					const auto min = std::min(rezerve[j], pacijent.potrebne_jedinice);

					rezerve[j] -= min;
					pacijent.potrebne_jedinice -= min;
					raspodela[j] += min;
				}

				continue;
			}

		}

	}

	std::cout << "moguce\n";

	for (const auto& raspodela : raspodele) {
		std::printf("%lu %lu %lu %lu\n", raspodela[0], raspodela[1], raspodela[2], raspodela[3]);
	}
	
}